<?php
// trainee/chat_endpoint.php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/trainer_bot_functions.php';
require_once __DIR__ . '/includes/openrouter_handler.php';

header('Content-Type: application/json');
ini_set('display_errors', 0); // Prevent HTML errors breaking JSON

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

if (!$input) {
    file_put_contents(__DIR__ . '/debug_chat.log', date('Y-m-d H:i:s') . " - No Input\n", FILE_APPEND);
    echo json_encode(['error' => 'Invalid input']);
    exit;
}

$action = $input['action'] ?? '';
file_put_contents(__DIR__ . '/debug_chat.log', date('Y-m-d H:i:s') . " - Action: $action\n", FILE_APPEND);

$traineeId = $_SESSION['trainee_id'];

if ($action === 'send_message') {
    $sessionId = $input['session_id'];
    $message = trim($input['message']);
    
    // Validate Session ownership
    $activeSession = getActiveSession($traineeId);
    if (!$activeSession || $activeSession['id'] != $sessionId) {
        echo json_encode(['error' => 'Invalid or inactive session']);
        exit;
    }

    // 1. Save User Message
    addChatMessage($sessionId, 'trainee', $message);

    // 2. Build Context for Bot
    // Fetch recent history (including the one just added? Yes)
    // Actually getSessionChatHistory fetches from DB.
    $history = getSessionChatHistory($sessionId, 10); // get last 10 messages
    
    // 3. Call AI
    file_put_contents(__DIR__ . '/debug_chat.log', date('Y-m-d H:i:s') . " - Calling OpenRouter...\n", FILE_APPEND);
    
    // Convert history to format expected
    $messages = [];
    foreach ($history as $h) {
        $messages[] = ['role' => ($h['sender'] == 'bot' ? 'assistant' : 'user'), 'content' => $h['message']];
    }
    // Add current message which might not be in DB yet? 
    // Wait, line 37 addChatMessage adds it to DB. Line 42 fetches it. So it should be in $history.
    
    // callOpenRouter now handles system prompt internally
    $aiResponse = callOpenRouter($messages);
    
    if ($aiResponse) {
        file_put_contents(__DIR__ . '/debug_chat.log', date('Y-m-d H:i:s') . " - Response: " . substr(json_encode($aiResponse), 0, 200) . "...\n", FILE_APPEND);
        
        $botReply = formatBotResponse($aiResponse);
        
        // 4. Save Bot Message
        addChatMessage($sessionId, 'bot', $botReply);
        
        // Update Session Progress
        $currentProgress = $activeSession['progress_percentage'];
        $newProgress = $currentProgress;

        // heuristic: +5% per message, cap at 95% unless completion detected
        if ($currentProgress < 95) {
            $newProgress = min(95, $currentProgress + 5);
        }

        // Check for completion keywords
        $completionKeywords = ['mock test', 'proceed to the test', 'final exam', 'training is complete'];
        foreach ($completionKeywords as $keyword) {
            if (stripos($botReply, $keyword) !== false) {
                $newProgress = 100;
                break;
            }
        }

        if ($newProgress > $currentProgress) {
             $pdo = getDB();
             $pdo->prepare("UPDATE training_sessions SET progress_percentage = ? WHERE id = ?")->execute([$newProgress, $sessionId]);
        }
        
        echo json_encode(['success' => true, 'reply' => $botReply]);
    } else {
        file_put_contents(__DIR__ . '/debug_chat.log', date('Y-m-d H:i:s') . " - AI Response FAILED (False returned)\n", FILE_APPEND);
        echo json_encode(['success' => false, 'error' => 'AI Brain Disconnected (API returned false)']);
    }
}
elseif ($action === 'check_updates') {
    // For polling new messages (simple version)
    $sessionId = $input['session_id'];
    $lastId = $input['last_id'] ?? 0;
    
    $pdo = getDB();
    $stmt = $pdo->prepare("SELECT * FROM chat_messages WHERE session_id = ? AND id > ? ORDER BY id ASC");
    $stmt->execute([$sessionId, $lastId]);
    $newMessages = $stmt->fetchAll();
    
    echo json_encode(['success' => true, 'messages' => $newMessages]);
}
?>
