<?php
// trainee/header.php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/auth.php';
?>
<!DOCTYPE html>
<html lang="en" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DSGC Trainee - Training Center</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/trainer_bot.css">
    <style>
        body { padding-top: 80px; }
        .trainee-navbar {
            background: rgba(18, 18, 20, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--border-color);
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg fixed-top trainee-navbar">
    <div class="container-fluid px-4">
        <a class="navbar-brand d-flex align-items-center" href="dashboard.php">
            <i class="bi bi-robot fs-3 text-accent me-2"></i>
            <div>
                <div class="fw-bold text-white lh-1">DSGC</div>
                <small class="text-secondary fw-bold" style="font-size: 0.6rem; letter-spacing: 1px;">TRAINING CENTER</small>
            </div>
        </a>
        
        <button class="navbar-toggler border-0 text-white" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <i class="bi bi-list fs-1"></i>
        </button>

        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto align-items-center">
                <li class="nav-item me-3">
                    <span class="badge bg-light bg-opacity-10 border border-white border-opacity-10 py-2 px-3">
                        <i class="bi bi-person-fill me-1"></i> <?php echo htmlspecialchars($_SESSION['trainee_nick']); ?>
                    </span>
                </li>
                <li class="nav-item">
                    <a href="logout.php" class="btn btn-sm btn-outline-danger fw-bold">Log Out</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="container-fluid px-4 py-4">
