<?php
// trainee_login.php
session_start();
require_once 'includes/db.php';
require_once 'includes/trainer_bot_functions.php';

if (isset($_SESSION['trainee_logged_in']) && $_SESSION['trainee_logged_in'] === true) {
    header("Location: dashboard.php");
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nick = trim($_POST['nick']);
    $pass = $_POST['password'];
    
    $trainee = authenticateTrainee($nick, $pass);
    if ($trainee) {
        $_SESSION['trainee_logged_in'] = true;
        $_SESSION['trainee_id'] = $trainee['id'];
        $_SESSION['trainee_nick'] = $trainee['trainee_nick'];
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Invalid credentials or account suspended.";
    }
}
?>
<!DOCTYPE html>
<html lang="en" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <title>DSGC Trainee Access</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="d-flex align-items-center justify-content-center" style="min-height: 100vh; background: var(--bg-color);">
    <div class="login-card p-5 rounded-4 shadow-lg text-center" style="background: var(--surface-color); border: 1px solid var(--border-color); width: 100%; max-width: 400px;">
        <div class="mb-4">
            <i class="bi bi-robot fs-1 text-accent"></i>
            <h3 class="fw-bold text-white mt-3">TRAINING BOT</h3>
            <p class="text-secondary small text-uppercase fw-bold ls-wide">Admin Access Protocol</p>
        </div>
        
        <?php if($error): ?>
            <div class="alert alert-danger bg-transparent border-danger text-danger py-2 mb-4 small fw-bold"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-3 text-start">
                <label class="small text-secondary fw-bold mb-1">Trainee Nickname</label>
                <input type="text" name="nick" class="form-control" required style="background: var(--bg-color); border-color: var(--border-color); color: #fff;">
            </div>
            <div class="mb-4 text-start">
                <label class="small text-secondary fw-bold mb-1">Password</label>
                <input type="password" name="password" class="form-control" required style="background: var(--bg-color); border-color: var(--border-color); color: #fff;">
            </div>
            <button type="submit" class="btn btn-prof btn-prof-primary w-100 py-2">INITIATE SESSION</button>
        </form>
        
        <div class="mt-4 text-center">
            <a href="../index.php" class="text-secondary small text-decoration-none">Return to Public Sector</a>
        </div>
    </div>
</body>
</html>
