<?php
// trainee/test.php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/trainer_bot_functions.php';

$traineeId = $_SESSION['trainee_id'];
$sessionId = isset($_GET['session_id']) ? (int)$_GET['session_id'] : 0;
$materialId = 0;
$materialName = "Training Test";

if ($sessionId) {
    // Get session info only
    $pdo = getDB();
    $stmt = $pdo->prepare("SELECT * FROM training_sessions WHERE id = ?");
    $stmt->execute([$sessionId]);
    $res = $stmt->fetch();
    if ($res) {
        $materialId = 0; // Global
        $materialName = "General Admin Certification"; // Hardcoded title
    } else {
        header("Location: dashboard.php");
        exit;
    }
} else {
    // Redirect to dashboard if no session
    header("Location: dashboard.php");
    exit;
}

include 'header.php';
?>
<link rel="stylesheet" href="css/trainer_test_custom.css">

<div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="d-flex justify-content-between align-items-center mb-4 text-white">
            <div>
                 <small class="text-secondary text-uppercase fw-bold ls-wide">Final Assessment</small>
                 <h4 class="fw-bold mb-0"><?php echo htmlspecialchars($materialName); ?></h4>
            </div>
            <div id="timer" class="d-none">
                <i class="bi bi-stopwatch text-warning me-2"></i> <span class="fw-bold font-monospace fs-5">00:00</span>
            </div>
        </div>

        <!-- Loading State -->
        <div id="loading" class="text-center py-5">
            <div class="spinner-border text-accent mb-3" role="status"></div>
            <p class="text-white">Generating certification exam from training material...</p>
            <small class="text-secondary">This leverages AI to create unique questions. Please wait.</small>
        </div>

        <!-- Test Container -->
        <div id="testContainer" class="d-none">
            <input type="hidden" id="materialId" value="<?php echo $materialId; ?>">
            
            <form id="testForm">
                <div id="questionsList">
                    <!-- Questions injected by JS -->
                </div>

                <div class="d-flex justify-content-between mt-4 border-top border-secondary border-opacity-25 pt-4">
                    <button type="button" class="btn btn-outline-light px-4" id="prevBtn" disabled>Previous</button>
                    <div id="progressText" class="text-white align-self-center">Question 1 of ?</div>
                    <button type="button" class="btn btn-prof btn-prof-primary px-4" id="nextBtn">Next</button>
                    <button type="submit" class="btn btn-success px-4 d-none" id="submitBtn">Submit Exam</button>
                </div>
            </form>
        </div>

        <!-- Result Container -->
        <div id="resultContainer" class="d-none text-center py-5 prof-card" style="background: var(--surface-color);">
            <div class="mb-4">
                <i id="resultIcon" class="bi bi-award fs-1 text-accent"></i>
            </div>
            <h3 class="fw-bold text-white mb-2" id="resultTitle">Assessment Complete</h3>
            <div class="display-2 fw-bold mb-3" id="resultScore">0%</div>
            <p class="text-secondary mb-4" id="resultMsg">Calculating...</p>
            
            <a href="dashboard.php" class="btn btn-prof btn-prof-primary px-5">Return to Dashboard</a>
        </div>
    </div>
</div>

<script src="js/trainer_test.js"></script>

<?php include 'footer.php'; ?>
