<?php
// trainee/test_endpoint.php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/trainer_bot_functions.php';

header('Content-Type: application/json');

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $action = $input['action'] ?? '';
    $traineeId = $_SESSION['trainee_id'];
    
    if ($action === 'start_test') {
        $materialId = (int)$input['material_id'];
        
        // Generate (or fetch existing) questions
        error_log("Generating questions for material_id: $materialId");
        $questions = generateTestQuestions($materialId, 'basic');
        error_log("Generated " . count($questions) . " questions");
        
        // We send back questions WITHOUT correct answers / explanations
        $sanitized = [];
        foreach($questions as $q) {
            $sanitized[] = [
                'id' => $q['id'],
                'text' => $q['question_text'],
                'type' => $q['question_type'] ?? 'mcq',
                'options' => is_string($q['options']) ? json_decode($q['options']) : $q['options']
            ];
        }
        
        echo json_encode(['success' => true, 'questions' => $sanitized]);
    } 
    elseif ($action === 'submit_test') {
        $materialId = (int)$input['material_id'];
        $answers = $input['answers']; // Array of {question_id, answer}
        
        $result = submitTestAttempt($traineeId, $materialId, $answers);
        echo json_encode($result);
    } 
    else {
        echo json_encode(['success' => false, 'error' => 'Invalid action']);
    }
} catch (Exception $e) {
    error_log("Test endpoint error: " . $e->getMessage());
    error_log("Stack trace: " . $e->getTraceAsString());
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
